/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.core;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeapolitanConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> milkingWithGlassBottles;
        public final ForgeConfigSpec.ConfigValue<Integer> milkBucketUseTime;
        public final ForgeConfigSpec.ConfigValue<Integer> strawberryBushGenerationChance;
        public final ForgeConfigSpec.ConfigValue<Integer> vanillaVineGenerationChance;
        public final ForgeConfigSpec.ConfigValue<Integer> adzukiSproutsGenerationChance;
        public final ForgeConfigSpec.ConfigValue<Integer> mintPondGenerationChance;
        public final ForgeConfigSpec.ConfigValue<Boolean> bananaPlantBeachGeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> bananaPlantJungleGeneration;
        public final ForgeConfigSpec.ConfigValue<Boolean> plantainSpiderSpawning;
        public final ForgeConfigSpec.ConfigValue<Boolean> plantainSpidersFromBundles;
        public final ForgeConfigSpec.ConfigValue<Boolean> plantainSpidersGiveSlipping;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("items");
            this.milkingWithGlassBottles = builder.comment("If milkable mobs can be milked with empty glass bottles").define("Milking with Glass Bottles", false);
            this.milkBucketUseTime = builder.comment("The use time for Milk Buckets, in ticks").define("Milk Bucket drink time", (Object)32);
            builder.pop();
            builder.push("worldgen");
            builder.push("features");
            this.strawberryBushGenerationChance = builder.defineInRange("Strawberry Bush generation chance in Plains", 9, 0, 128);
            this.vanillaVineGenerationChance = builder.defineInRange("Vanilla Vine generation chance in Savannas", 6, 0, 128);
            this.adzukiSproutsGenerationChance = builder.defineInRange("Aduzki Sprouts generation chance in Forests", 7, 0, 128);
            this.mintPondGenerationChance = builder.defineInRange("Mint pond generation chance in Mountains", 5, 0, 128);
            this.bananaPlantBeachGeneration = builder.define("Banana Plant generation in Beaches", true);
            this.bananaPlantJungleGeneration = builder.define("Banana Plant generation in Jungles", true);
            builder.pop();
            builder.pop();
            builder.push("entities");
            builder.push("plantain_spider");
            this.plantainSpiderSpawning = builder.define("Plantain Spider spawning in Jungles", true);
            this.plantainSpidersFromBundles = builder.define("Plantain Spider spawn from Banana Bundles", true);
            this.plantainSpidersGiveSlipping = builder.define("Plantain Spiders give Slipping", true);
            builder.pop();
            builder.pop();
        }
    }
}

